<?php
/**
 * Plugin Name: MultiCol
 * Plugin URI: https://webdav.incredulous.org/wordpress-plugin-for-multicolumn-block
 * Description: This is a plugin which adds a block that supports multiple columns for text and images.
 * Version: 0.1
 * Author: Dave Wise
 *
 * @package multicol
 */

defined( 'ABSPATH' ) || exit;

/**
 * Load all translations for our plugin from the MO file.
 */
function multicol_load_textdomain() {
	load_plugin_textdomain( 'multicol', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'init', 'multicol_load_textdomain' );

/**
 * Register the block assets so that they can be enqueued through Gutenberg
 *
 * Pass translations to JavaScript.
 */

if (! function_exists('multicol_register_block()') ): 
function multicol_register_block() {

	if ( ! function_exists( 'register_block_type' ) ) {
		return;  // Gutenberg is not active so don't do anything.
	}

  wp_register_script('multicol-script', plugins_url('/multicol.js', __FILE__), array('wp-blocks', 'wp-element'));
  wp_register_style ('multicol-style',  plugins_url('/multicol.css', __FILE__), array( 'wp-edit-blocks' ), filemtime( plugin_dir_path(__FILE__) . 'multicol.css' ));

  // Blockname = namespace/name
	register_block_type( 'multicol/multicol', array( 'editor_script' => 'multicol-script', 'editor_style' => 'multicol-style', 'style' => 'multicol-style') );

	if ( function_exists( 'wp_set_script_translations' ) ) {
		wp_set_script_translations( 'multicol', 'multicol' );
	}

}
endif;
add_action( 'init', 'multicol_register_block' );
