/**
 *
 */

var el = wp.element.createElement,
    registerBlockType = wp.blocks.registerBlockType,
    InspectorControls = wp.blockEditor.InspectorControls,
    components = wp.components,
    InnerBlocks = wp.blockEditor.InnerBlocks,
    i18n = wp.i18n;

registerBlockType( 'multicol/multicol', {
  title: "Multicolumn Block",
  name: "multicol/multicol",
  category: "text",
  icon: "columns",
  textdomain: "multicol",


  attributes: {
    columns: {
      type: 'string',
      default: '1'
    },
    usecolours: {
      type: 'boolean',
    },
    background: { 
      type: 'string',
      default: 'inherit'
    },
    usepadding: {
      type: 'boolean',
    }
  },
  
  edit: ( props ) => {
    /**
     * Variables to use on the block and in the settings panel on the right 
     */
    var columns = props.attributes.columns,
        TextControl = components.TextControl,
        CheckboxControl = components.CheckboxControl,
        ColourControl = components.ColorPicker,
        background = props.attributes.background,
        usecolours = props.attributes.usecolours,
        usepadding = props.attributes.usepadding,
        pd = 'inherit',
        bg = 'inherit';

    // Change the defaults is the settings are chosen
    if (usecolours == true) bg = background;
    if (usepadding == true) pd = '1.6rem';

    return [
      el( InspectorControls, {}, 
        el(components.PanelBody, { title: i18n.__('Block Settings', 'multicol'), className: 'block-content', initialOpen: true },
          el( TextControl, { style: { maxWidth: '40%', marginLeft: '1.25rem', marginRight: 'auto' }, label: 'Columns', value: props.attributes.columns, onChange: ( value ) => { props.setAttributes( { columns: value } ); } } ),
          el( 'h2', {className: 'components-panel__body-title', style: { margin: '-16px -16px 5px auto' } }, i18n.__('Use Background') ),
          el(CheckboxControl, { label: i18n.__( 'Use Colours', 'multicol' ), checked: usecolours, onChange:  ( value ) => { props.setAttributes( { usecolours: value } ); } }),
          el( 'h2', {className: 'components-panel__body-title', style: { margin: '-16px -16px 5px auto' } }, i18n.__('Background Colour') ),
          el( ColourControl, { label: 'Background', color: props.attributes.background, onChange: ( value ) => { props.setAttributes( { background: value } ); } } ),
          el( CheckboxControl, { label: i18n.__( 'Add Padding', 'multicol' ), checked: usepadding, onChange:  ( value ) => { props.setAttributes( { usepadding: value } ); } }),
        )),
      el( 'div', { className: props.className, style: { columnCount: columns, backgroundColor: bg, padding: pd } } , el( InnerBlocks )), 
     ]; // Can't beat a bit of WYSIWYG editing ...
  }, 
  
  save: ( props ) => {
    var columns = props.attributes.columns,
        background = props.attributes.background,
        usepad = props.attributes.usepadding,
        padding = '1.6rem',
        usecolours  = props.attributes.usecolours;

    // Change the defaults if the settings are chosen
    if (!usecolours) background = 'inherit'; 
    if (!usepad) padding = 'inherit';

    // Output the content inside the column framework
    return el( 'div', {
      className: props.className,
      style: { columnCount: columns, backgroundColor: background, padding: padding },
    }, el(InnerBlocks.Content) );
  },
});
